(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6601,        205]*)
(*NotebookOutlinePosition[      7440,        232]*)
(*  CellTagsIndexPosition[      7396,        228]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(Integrate[t\ \((t - 1)\)*Log[m - t], \ {t, \ 0, \ 2}] // Simplify\)], 
  "Input"],

Cell[BoxData[
    \(1\/18\ 
      \((2 + 6\ m - 12\ m\^2 + 3\ \((3 - 2\ m)\)\ m\^2\ Log[2 - m] + 
          12\ Log[\(-2\) + m] + 3\ m\^2\ \((\(-3\) + 2\ m)\)\ Log[\(-m\)])
        \)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[\((1 - t)\)\ \((2 - t)\)*Log[m - t], \ {t, \ 0, \ 2}] // 
      Simplify\)], "Input"],

Cell[BoxData[
    \(1\/18\ 
      \((\(-34\) + 42\ m - 12\ m\^2 - 
          3\ m\ \((12 - 9\ m + 2\ m\^2)\)\ Log[2 - m] + 12\ Log[\(-2\) + m] + 
          3\ m\ \((12 - 9\ m + 2\ m\^2)\)\ Log[\(-m\)])\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[t\ \((2 - t)\)*Log[m - t], \ {t, \ 0, \ 2}] // Simplify\)], 
  "Input"],

Cell[BoxData[
    \(1\/9\ 
      \((3\ \((\(-3\) + m)\)\ m\^2\ Log[2 - m] + 
          2\ \((\(-5\) - 6\ m + 3\ m\^2 + 6\ Log[\(-2\) + m])\) - 
          3\ \((\(-3\) + m)\)\ m\^2\ Log[\(-m\)])\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Psi]0[m_] := m\ log[m] - \((m - 2)\)\ log[m - 2] - 2; \n
    \[Psi]1[m_] := \ 
      \((1/2)\)*\((\ \((m - 2)\)^2\ log[m - 2] - m^2\ log[m])\)\  + \n
        \t\t\t\t\t\t\t\t\t\((1/4)\)*\((m^2 - \((m - 2)\)^2)\) + m*\[Psi]0[m]; 
    \n\[Psi]2[m_] := \ 
      \((1/3)\)*\((\ m^3\ log[m] - \((m - 2)\)^3\ log[m - 2])\)\  + \n\t\t
        \((1/9)\)*
          \((\ \((m - 2^3 - m^3)\)\  + 
              m*\((\ 2\ \[Psi]1[m] - m*\[Psi])\)[m]\ )\); \n
    \[Psi]2[m] - \[Psi]1[m] // Simplify\)], "Input"],

Cell[BoxData[
    \(1\/18\ 
      \((2 + 20\ m - 2\ m\^3 - 
          3\ \((\(-4\) + 24\ m - 15\ m\^2 + 2\ m\^3)\)\ log[\(-2\) + m] + 
          3\ m\^2\ \((\(-3\) + 2\ m)\)\ log[m] + 
          2\ m\ \((
                \(-2\) - 2\ m - m\ \[Psi] - 
                  \((\(-4\) + m\^2)\)\ log[\(-2\) + m] + m\^2\ log[m])\)[m])
        \)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(2*\[Psi]0[m] - 3*\[Psi]1[m] + \[Psi]2[m] // Simplify\)], "Input"],

Cell[BoxData[
    \(1\/18\ 
      \((\(-34\) + 56\ m - 2\ m\^3 - 
          3\ \((\(-4\) + 36\ m - 21\ m\^2 + 2\ m\^3)\)\ log[\(-2\) + m] + 
          3\ m\ \((12 - 9\ m + 2\ m\^2)\)\ log[m] + 
          2\ m\ \((
                \(-2\) - 2\ m - m\ \[Psi] - 
                  \((\(-4\) + m\^2)\)\ log[\(-2\) + m] + m\^2\ log[m])\)[m])
        \)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(2*\[Psi]1[m] - \[Psi]2[m] // Simplify\)], "Input"],

Cell[BoxData[
    \(1\/9\ 
      \((\(-10\) - 19\ m + m\^3 + 
          3\ \((4 + 12\ m - 9\ m\^2 + m\^3)\)\ log[\(-2\) + m] - 
          3\ \((\(-3\) + m)\)\ m\^2\ log[m] - 
          m\ \((\(-2\) - 2\ m - m\ \[Psi] - 
                  \((\(-4\) + m\^2)\)\ log[\(-2\) + m] + m\^2\ log[m])\)[m])
        \)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Equal[
      1\/18\ \((
            2 + 6\ m - 12\ m\^2 + 3\ \((3 - 2\ m)\)\ m\^2\ Log[2 - m] + 
              12\ Log[\(-2\) + m] + 3\ m\^2\ \((\(-3\) + 2\ m)\)\ Log[\(-m\)])
            \) == 1\/18\ 
          \((2 + 20\ m - 2\ m\^3 - 
              3\ \((\(-4\) + 24\ m - 15\ m\^2 + 2\ m\^3)\)\ log[\(-2\) + m] + 
              3\ m\^2\ \((\(-3\) + 2\ m)\)\ log[m] + 
              2\ m\ \((
                    \(-2\) - 2\ m - m\ \[Psi] - 
                      \((\(-4\) + m\^2)\)\ log[\(-2\) + m] + m\^2\ log[m])\)[
                  m])\)]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Equal[
      1\/18\ \((
            \(-34\) + 42\ m - 12\ m\^2 - 
              3\ m\ \((12 - 9\ m + 2\ m\^2)\)\ Log[2 - m] + 
              12\ Log[\(-2\) + m] + 
              3\ m\ \((12 - 9\ m + 2\ m\^2)\)\ Log[\(-m\)])\) == 
        1\/18\ \((
            \(-34\) + 56\ m - 2\ m\^3 - 
              3\ \((\(-4\) + 36\ m - 21\ m\^2 + 2\ m\^3)\)\ log[\(-2\) + m] + 
              3\ m\ \((12 - 9\ m + 2\ m\^2)\)\ log[m] + 
              2\ m\ \((
                    \(-2\) - 2\ m - m\ \[Psi] - 
                      \((\(-4\) + m\^2)\)\ log[\(-2\) + m] + m\^2\ log[m])\)[
                  m])\)]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Equal[
      1\/9\ \((3\ \((\(-3\) + m)\)\ m\^2\ Log[2 - m] + 
              2\ \((\(-5\) - 6\ m + 3\ m\^2 + 6\ Log[\(-2\) + m])\) - 
              3\ \((\(-3\) + m)\)\ m\^2\ Log[\(-m\)])\) == 
        1\/9\ \((
            \(-10\) - 19\ m + m\^3 + 
              3\ \((4 + 12\ m - 9\ m\^2 + m\^3)\)\ log[\(-2\) + m] - 
              3\ \((\(-3\) + m)\)\ m\^2\ log[m] - 
              m\ \((\(-2\) - 2\ m - m\ \[Psi] - 
                      \((\(-4\) + m\^2)\)\ log[\(-2\) + m] + m\^2\ log[m])\)[
                  m])\)]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 509},
WindowMargins->{{4, Automatic}, {Automatic, -2}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 101, 2, 27, "Input"],
Cell[1835, 55, 197, 4, 60, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2069, 64, 115, 2, 27, "Input"],
Cell[2187, 68, 217, 4, 60, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2441, 77, 101, 2, 27, "Input"],
Cell[2545, 81, 209, 4, 60, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2791, 90, 522, 10, 107, "Input"],
Cell[3316, 102, 351, 8, 77, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3704, 115, 85, 1, 27, "Input"],
Cell[3792, 118, 360, 8, 77, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4189, 131, 70, 1, 27, "Input"],
Cell[4262, 134, 321, 7, 77, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4620, 146, 579, 12, 135, "Input"],
Cell[5202, 160, 38, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5277, 166, 634, 14, 137, "Input"],
Cell[5914, 182, 38, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5989, 188, 555, 11, 137, "Input"],
Cell[6547, 201, 38, 1, 26, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

